\name{fiber.angle}
\alias{fiber.angle}
\title{
\strong{Experimental!} Calculating the orientation of muscle fibers}
\description{
Calculating the angle of individual muscle fibers. This function can only calculate fiber angles around a central axis (x, y or z) or in reference to a particular "view" (plane). Fiber data is centered around the other axes.

Will eventually include an option for a tendon image stack. Not yet complete}
\usage{
fiber.angle(fib.list, axis, centered = TRUE, reference = "axis")
}
\arguments{
  \item{fib.list}{
A list of muscle fiber paths generated by good.fibes or from the various cleaning and processing function (must contain $fiber.points).
}
  \item{axis}{
The axis around which angles will be calculated as a deviation from. Default is 3 (z). This axis is treated as the "z" axis for "plane" options.
}
  \item{centered}{
Should the data be centered on the other two axes before calculation.
}
  \item{reference}{
Should the angles be calculated about an axis (specified by "axis") or in reference to a plane ("plane.xz" or "plane.yz", where z is the value of "axis").
}
}
\value{
A vector of angles in degrees corresponding to each fiber in the original list}
\references{
Arbour, J. 2023. GoodFibes: an R package for the detection of muscle fibers from diceCT scans. \emph{Integrative Organismal Biology} 5(1): obad030.

Katzke, J., Puchenkov, P., Stark, H., and Economo, E. 2022. A Roadmap to Reconstructing Muscle Architecture from CT Data. \emph{Integrative Organismal Biology} 4(1): 1-16.

Sullivan, S., McGechie, F., Middleton, K., and Holliday, C. 3D Muscle Architecture of the Pectoral Muscles of European Starling (Sturnus vulgaris).\emph{Integrative Organismal Biology} 1(1):1-18.

}
\author{
J. Arbour
}
\note{
\strong{NOT TOTALLY VERIFIED YET, USE WITH CAUTION}
}
\seealso{
\code{\link{fiber.lengths}}
}
\examples{

\donttest{
olddir<-getwd()

data(ant.final)
fangle<-fiber.angle(ant.final,3)
fangle

cols<-color.scale(fangle, "blue", "red")
muscle.plot.stl(ant.final, cols=cols, df = 1)

setwd(olddir)
}
}
