% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Rarefaction.R
\name{Plot_Rarefaction}
\alias{Plot_Rarefaction}
\title{Plots the measured value versus rarefied samples or percent error of estimates (PEE) of a rarefied samples for a geographic range measure}
\usage{
Plot_Rarefaction(Mes1_AllTaxa, Mes2_AllTaxa, symbol = 20, measure = 2,
  SampSize = 1, color = "black")
}
\arguments{
\item{Mes1_AllTaxa}{- Vector list of measured values for multiple taxa, from the GeoRarefaction_MultiTaxa function, or PEE calculations for multiple taxa, from from PEE_MultiTaxa function}

\item{Mes2_AllTaxa}{- Vector list of measured values for multiple taxa, output from GeoRarefaction_MultiTaxa function}

\item{symbol}{- Symbol used for plotting, as per pch graphical parameter}

\item{measure}{- Specifies which measure to be plotted, 2=MST 3=CH 4=GCD 5=LatRg 6=LongRg 7=CellCount}

\item{SampSize}{- Specifies the index value of the rarefaction sample size from the PEE_AllTaxa parameter}

\item{color}{- Specifies the color of symbols being plotted}
}
\value{
Returns a plot of measured geographic range values or PEE versus true value for a specific geographic range measure at varying sample sizes
}
\description{
Plots the measured value versus rarefied samples or percent error of estimates (PEE) of a rarefied samples for a geographic range measure
}
\details{
For each taxon for a specific geographic range measure using 95% confindence intervals rather than standard deviations as the error bars
Measure paramter is the ordinal position of the measure of interest 2=MST,3=CH,4=GCD,5=LatRg,6=LongRg,7=CellCount
SampSize parameter indicates the index column position of steps size, default is first column (all points)
}
\examples{
\dontrun{
data(BivalvePBDB)
BivalveMatrix<-CoordList_PBDB(BivalvePBDB)
BivalveGeo<-GeoRarefaction_MultiTaxa(nLocCut=20,OccMatrix=BivalveMatrix,TaxaStart=3,replacePts=TRUE)
BivalvePEE<-PEE_MultiTaxa(BivalveGeo)
Plot_Rarefaction(BivalvePEE,BivalveGeo,symbol=20,measure=2,SampSize=2)
}
}
