#'@title Function used to perform parallel computing for weighted norm of multidimensional Brownian motion
#'
#'@description This function simulates weighted Euclidean norm for multidimensional BM.
#'
#'@param n          Number of simulated points;
#'@param d          Dimension of BM;
#'@param gamma      Weighted exponent (>= 0, < 0.5).
#
#'
#'
#'@return \item{stat}{Weighted norm of multidimensional BM}
#'
#'@keywords internal
#'
#'@export
#'
#'

funBM <- function(n,d,gamma)
{
  W <- SimBM(n,d)
  W=W[-1,]
  if(d==1){ norm=abs(W)}else{
    W2=W*W
    norm <- sqrt(apply(W2, 1, sum))
  }
  t = c(1:n)/n
  stat = max(norm/t^gamma)
  return(stat)
}
