% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.mtd.R
\name{multi.mtd}
\alias{multi.mtd}
\title{Estimation of Multivariate Markov Chains - MTD model}
\usage{
multi.mtd(y, deltaStop = 1e-04, is_constrained = TRUE, delta = 0.1)
}
\arguments{
\item{y}{matrix of categorical data sequences}

\item{deltaStop}{value below which the optimization phases of the parameters stop}

\item{is_constrained}{flag indicating whether the function will consider the usual set of constraints (usual set: \emph{TRUE}, new set of constraints: \emph{FALSE}).}

\item{delta}{the amount of change to increase/decrease in the parameters for each iteration of the optimization algorithm.}
}
\value{
The function returns a list with the parameter estimates, standard-errors, z-statistics, p-values and the value of the log-likelihood function, for each equation.
}
\description{
This function estimates the Mixture Distribution Model (Raftery (1985)) for Multivariate Markov Chains.
It considers Berchtold (2001) optimization algorithm for the parameters and estimates the probabilities transition matrices as proposed in Ching (2002).
}
\note{
See details of the optimization procedure in \href{https://onlinelibrary.wiley.com/doi/abs/10.1111/1467-9892.00231}{Berchtold (2001)}.
}
\examples{
data(stockreturns)
s <- cbind(stockreturns$sp500, stockreturns$djia)
multi.mtd(s)
}
\references{
Raftery, A. E. (1985). A Model for High-Order Markov Chains. Journal of the Royal Statistical Society. Series B (Methodological), 47(3), 528-539. \url{http://www.jstor.org/stable/2345788}

Berchtold, A. (2001). Estimation in the Mixture Transition Distribution Model. Journal of Time Series Analysis, 22(4), 379-397.\doi{10.1111/1467-9892.00231}

Ching, W. K., E. S. Fung, and M. K. Ng (2002). A multivariate Markov chain model for categorical data sequences and its applications in demand predictions. IMA Journal of Management Mathematics, 13(3), 187-199. \doi{10.1093/imaman/13.3.187}
}
