% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viIG.R
\name{viiG.fun}
\alias{viiG.fun}
\title{Function for VIiG}
\usage{
viiG.fun(X, l)
}
\arguments{
\item{X}{A positive continuous random variable}

\item{l}{The shape parameter of the inverse Gaussian distribution}
}
\value{
Returns
\item{viiG}{The inverse Gaussian variation index}
}
\description{
The function computes the inverse Gaussian variation index with shape parameter \eqn{l\in (0,\infty)}.
}
\details{
\code{viiG.fun} computes the variation index with respect to the inverse Gaussian distribution. See Touré et al. (2020) for more details.
}
\examples{
X<-c(0.12,9.11,0.03,8.71,5.02,7.12,6.42,5.73)
viiG.fun(X,0.05)
Y<-c(0.003,6.283,1.001,3.112,4.342,2.890,5.005)
viiG.fun(Y,0.3)
}
\references{
Touré, A.Y., Dossou-Gbété, S. and Kokonendji, C.C. (2020). Asymptotic normality of the test statistics for relative dispersion and relative variation indexes, \emph{Journal of Applied Statistics} \bold{47}, 2479-2491.
}
\author{
Aboubacar Y. Touré and Célestin C. Kokonendji
}
