% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{predictions}
\alias{predictions}
\title{Predictions Function: Generate predictions using classifiers from RWeka}
\usage{
predictions(Xdata, Ydata)
}
\arguments{
\item{Xdata}{Matrix. A dataset where rows represent observations and columns represent features.}

\item{Ydata}{Vector. The actual response variable associated with each row in \code{Xdata}.}
}
\value{
A list containing predictions from the three models:
\describe{
\item{\code{predictionRF}}{Predictions from the Random Forest (RF) model.}
\item{\code{predictionSVM}}{Predictions from the Support Vector Machine (SVM) model.}
\item{\code{predictionLR}}{Predictions from the Logistic Regression (LR) model.}
}
}
\description{
This function trains three different classifiers—Random Forest (RF), Support Vector Machine (SVM), and Logistic Regression (LR)—on the input dataset and returns their predictions.
}
\details{
The function utilizes the RWeka package to build three different classifiers:
Random Forest (RF), Support Vector Machine (SVM), and Logistic Regression (LR). It then
predicts the response variable for the input data using each of these models.
}
\examples{
# Example usage:

X <- matrix(rnorm(100), ncol=5)
Y <- sample(0:1, 20, replace=TRUE)
predictions(X, Y)

}
\references{
Davila-Pena, L., Saavedra-Nieves, A., & Casas-Méndez, B. (2024). \emph{On the influence of dependent features in classification problems: a game-theoretic perspective}. arXiv preprint. \doi{10.48550/arXiv.2408.02481}.
}
