% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mell.R
\name{Mell}
\alias{Mell}
\title{Mell Function: Subset Data Based on Group Index Conditions}
\usage{
Mell(Xdata, Ydata, index, ell)
}
\arguments{
\item{Xdata}{Matrix. A dataset where rows represent observations and columns represent features.}

\item{Ydata}{Vector. The response variable associated with each row in \code{Xdata}.}

\item{index}{Vector. A grouping vector that assigns each feature in \code{Xdata} to a specific union. E.g., if we
have the partition set P=\{\{1\},\{2,4\},\{3\}\}, then index=c(1,2,3,2).}

\item{ell}{Integer. The index of the union to exclude from the comparison.}
}
\value{
A list containing the following components:
\describe{
\item{Xdata.ell}{A subset of \code{Xdata} that meets the specified group conditions.}
\item{Ydata.ell}{The corresponding values from \code{Ydata} for the selected rows in \code{Xdata.ell}.}
\item{n.user.ell}{The number of selected rows that meet the group condition.}
}
}
\description{
The \code{Mell} function computes equation (1) in page 9 of Davila-Pena et al. (2024)
when the dependency is positive and features are binary. It filters rows from \code{Xdata} and \code{Ydata} based on specific conditions
of features' dependency as defined by \code{index}. It selects rows where the values
of features within the same union, except for those in union \code{ell}, coincide.
}
\details{
The \code{Mell} function iterates through each row of \code{Xdata} and compares the values of features
within predefined unions (determined by \code{index}). For each union, excluding the one specified
by \code{ell}, the function checks if all feature values in that union coincide.
If this condition is satisfied for all unions except \code{ell}, the row is selected.
}
\examples{
# Example usage from Example 5.2 in Davila-Pena et al. (2024):

library(CoopGame)
n.user <- 16
Xdata <- createBitMatrix(4)[,-5]
Xdata <- rbind(c(0,0,0,0),Xdata)
Ydata <- rep(0,n.user)
Ydata[1+c(10,11,13,14,15)] <- 1

# Scenario 1:
Mell(Xdata = Xdata, Ydata = Ydata, index = c(1,2,3,4), ell = 3)
# Scenario 9:
Mell(Xdata = Xdata, Ydata = Ydata, index = c(1,2,1,2), ell = 2)

}
\references{
Davila-Pena, L., Saavedra-Nieves, A., & Casas-Méndez, B. (2024). \emph{On the influence of dependent features in classification problems: a game-theoretic perspective}. arXiv preprint. \doi{10.48550/arXiv.2408.02481}.
}
