% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.grin.colors.R
\name{default.grin.colors}
\alias{default.grin.colors}
\title{Assign Default GRIN Colors}
\usage{
default.grin.colors(lsn.types)
}
\arguments{
\item{lsn.types}{A character vector of unique lesion types, typically derived from the lesion data.}
}
\value{
A named character vector of colors corresponding to each lesion type.
}
\description{
Assigns a default set of colors to lesion types for use in GRIN plots.
}
\details{
This function provides a predefined palette of up to 10 distinct colors for lesion types used in GRIN visualizations. If more than 10 lesion types are provided, the function will prompt the user to manually define custom colors to ensure visual distinction.
}
\examples{
data(lesion_data)

# Extract unique lesion types
lsn.types <- unique(lesion_data$lsn.type)

# Assign default colors to lesion types
default.grin.colors(lsn.types)
}
\references{
Pounds, S. B., et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
