% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{input_Tserie_area}
\alias{input_Tserie_area}
\title{Time series of annual load inputs by source and km2}
\usage{
input_Tserie_area(catch_data, annual_data, sh_file, basin_name, plot.type)
}
\arguments{
\item{catch_data}{data frame. Definition of the topological sequence of
catchments.}

\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{sh_file}{sf object. The spatial information.}

\item{basin_name}{character. The title of the plot}

\item{plot.type}{character. Alternative of the plot:  “gr1”:  stacked area by km2; “gr2”  lines & area by km2 and Shreve.}
}
\value{
A time-series plot
}
\description{
Creates a time series plot showing basin inputs by
source
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
data(sh_file)
# The title of the plot
plotTitle <- "Time series for the Lay Basin"
# the time serie plot 1 (by km2)
input_Tserie(catch_data_TN, annual_data_TN, sh_file, plotTitle, "gr1")
# the time serie plot 2 (by km2 and Shreve)
input_Tserie(catch_data_TN, annual_data_TN, sh_file, plotTitle, "gr2")
}
# catch_data <- The_Scen[[1]]
# annual_data <- The_Scen[[2]]
# sh_file <- The_Sf_shape
}
