% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRCdesigns.R
\name{SIGRC_II}
\alias{SIGRC_II}
\title{Structurally Incomplete Generalized Row Column Designs of Series-II}
\usage{
SIGRC_II(v)
}
\arguments{
\item{v}{= s^2 where s is a prime number}
}
\value{
This function generates structurally incomplete GRC designs from resolvable (Balanced Incomplete Block) BIB designs as well as the information matrix for estimating elementary treatment contrast.
}
\description{
This series generates using resolvable balanced incomplete block designs for a given v. The blocks are arranged in the row-column set up such that there should not be more than one blank cell in each row and column.
}
\examples{
library(GRCdesigns)
SIGRC_II(4)
}
\references{
1) Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2014). Structurally incomplete row-column designs with multiple units per cell. Statistics and Applications, 12(1&2), 71-79.

2)Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2015). Some series of row-column designs with multiple units per cell. Calcutta Statistical Association Bulletin, 67, ( 265-266), 89-99.

3)Datta, A., Jaggi, S., Varghese, C. and Varghese, E.  (2016). Series of incomplete row-column designs with two units per cell. Advances in Methodology and Statistics. 13(1), 17-25.
}
