% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoConverge.R
\name{autoConverge}
\alias{autoConverge}
\alias{autoConverge,ANY-method}
\title{Checks Stan model for convergence, then runs model on actual data.}
\usage{
autoConverge(
  df,
  controlVars,
  nUntreated,
  obvColName,
  obvName,
  outcomeName,
  starttime,
  timeColName,
  filepath = NULL,
  ncores = NULL,
  iter = 25000,
  epsilon = 0.02,
  noise = 0.1,
  printMod = FALSE,
  shift = 0.05
)
}
\arguments{
\item{df}{The dataframe used for the model.}

\item{controlVars}{String of column names for control variables.}

\item{nUntreated}{The number of untreated units in the model.}

\item{obvColName}{The column name that includes the observation subject to the counterfactual.}

\item{obvName}{The name of the observation subject to the counterfactual.}

\item{outcomeName}{The outcome variable of interest.}

\item{starttime}{The start time of the counterfactual estimation.}

\item{timeColName}{The name of the column that includes the time variable.}

\item{filepath}{Your preferred place to save the fit data. See Details.}

\item{ncores}{The number of cores to be used to run the model. Default of NULL will utilize all cores.}

\item{iter}{Preferred number of iterations. See details.}

\item{epsilon}{The desired level of convergence, i.e. how close to the 0.95 coverage is acceptable.}

\item{noise}{The baseline level of noise to be added to the model to prevent overfit. Updates as the model runs.}

\item{printMod}{Boolean. Defaults FALSE. If TRUE, prints the model block for the run to the console. See details.}

\item{shift}{The magnitude of adjustment for the noise level per iteration. Defaults to 0.05.}
}
\value{
The recommended noise level after convergence.
}
\description{
Return a converged Stan model fit and the recommended noise level.
}
\details{
We recommend creating a new folder for the file path since the Stan fit creates a large number of files at runtime.

For iterations, check that your model converged (we recommend all r-hats close to 1 and examining traceplots).

We recommend keeping printMod as FALSE, otherwise, the function will write the model to the console for every model run on the convergence.

We also recommend using all cores on your machine to speed up model run time. If you are unsure about the number of cores in your machine, see doParallel::detectCores().
}
\seealso{
\code{\link{plotGPPfit}} \code{\link{runMod}} \code{\link{GPP}} \code{\link{writeMod}}
}
\author{
Devin P. Brown \email{devinpbrown96@gmail.com} and David Carlson \email{carlson.david@wustl.edu}
}
