% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{simulated_function}
\alias{simulated_function}
\title{Simulate and Estimate Parameters of Growth Models}
\usage{
simulated_function(
  time_points = 1:10,
  n = 10,
  window_size = 3,
  model,
  parameter,
  sigma2 = 2,
  rho = 0.5,
  x_0 = 10,
  cov = FALSE,
  Plot_est = FALSE
)
}
\arguments{
\item{time_points}{A numeric vector representing the time points for which the data should be simulated.}

\item{n}{An integer specifying the number of independent trajectories to simulate.}

\item{window_size}{An integer specifying the window size for local estimation.}

\item{model}{A character string specifying the growth model to use. Options include 'Logistic', 'Exponential', 'Theta-logistic', 'Von-bertalanffy', and 'Gompertz'.}

\item{parameter}{A list of model-specific parameters required for the mean function.}

\item{sigma2}{A numeric value for the variance of the process.}

\item{rho}{A numeric value for the correlation coefficient.}

\item{x_0}{A numeric value for the initial state.}

\item{cov}{A logical value indicating whether to print the covariance matrix. Default is FALSE.}

\item{Plot_est}{A logical value indicating whether to plot the parameter estimates. Default is FALSE.}
}
\value{
A list containing the simulated data, global parameter estimates, global covariance matrix, local parameter estimates, and optionally local covariance matrices.
}
\description{
This function simulates data for independent trajectories based on specified growth models and estimates the model parameters.
The simulation can be performed for several models, including Logistic, Exponential, Theta-logistic, Von Bertalanffy, and Gompertz.
It also allows for calculation of global and local parameter estimates using the negative log-likelihood function.
}
\details{
The function first checks if the parameters are provided as a list. It then calculates the mean function based on the specified model and forms the covariance matrix. Multivariate normal data for the specified number of trajectories is generated using the mvtnorm::rmvnorm function. The negative log-likelihood function is defined and minimized using the optim function to estimate global parameters. Local parameter estimation is performed using a sliding window approach.

The available models are:
\itemize{
\item Logistic: Requires parameters r (growth rate) and K (carrying capacity).
\item Exponential: Requires parameter r (growth rate).
\item Theta-logistic: Requires parameters r (growth rate), theta, and K (carrying capacity).
\item Von-bertalanffy: Requires parameters r (growth rate) and K (asymptotic size).
\item Gompertz: Requires parameters b and c.
}
}
\examples{
res <- simulated_function(
 model = 'Logistic',
 parameter = list(r = 0.2, K = 100),
 cov = TRUE,
 Plot_est = TRUE)

}
