% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmc.R
\name{estimate_EY_X_squared}
\alias{estimate_EY_X_squared}
\title{Estimate E[(E[Y|X])^2] using kernel regression}
\usage{
estimate_EY_X_squared(X, Y, grid_length = 10000, kernel = dnorm)
}
\arguments{
\item{X}{A numeric vector of predictors.}

\item{Y}{A numeric vector of responses.}

\item{grid_length}{Number of grid points for numerical integration (default = 10000).}

\item{kernel}{Kernel function (default is dnorm).}
}
\value{
A list containing:
\describe{
  \item{estimate}{Estimated value of E[(E[Y|X])^2]}
  \item{bandwidth}{Selected kernel bandwidth}
  \item{mean_Y}{Mean of Y}
  \item{var_Y}{Variance of Y}
  \item{EY_grid}{Grid values of E[Y|X]}
  \item{fx_grid}{Estimated marginal density of X}
  \item{x_grid}{Grid points used in estimation}
}
}
\description{
This function estimates the squared conditional expectation E[(E[Y|X])^2] using
Nadaraya-Watson regression with Gaussian kernel.
}
\references{
Zheng, S., Shi, N.Z., & Zhang, Z. (2012).
  Generalized Measures of Correlation for Asymmetry, Nonlinearity, and Beyond.
  Journal of the American Statistical Association, 107(499), 1239-1252.
  \doi{10.1080/01621459.2012.710509}
}
\keyword{internal}
