% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Generate data for generalized linear models in simulation.}
\usage{
generate_data(seed, n, p, beta, alpha)
}
\arguments{
\item{seed}{Random seed.}

\item{n}{Number of samples}

\item{p}{Dimension of variable of interest}

\item{beta}{Coefficients for covariates Z}

\item{alpha}{Coefficients for variable of interest X}
}
\value{
A list object
}
\description{
\code{generate_data} returns simulated data, including response Y, covariates Z, and variable of interest X.
}
\examples{

p = 200
n = 100
beta = c(1,3,3)
s = 0.15
signal.r = 0.08
non.zero = floor(p * s)
seed = 2
alpha = c(rep(signal.r,non.zero),rep(0,p-non.zero))
dat = generate_data(seed, n = n, p = p, beta = beta,alpha = alpha)
#X, Y, cov
#dat$X; dat$Y; dat$cov

}
\author{
Chong Wu and Wei Pan
}
\references{
Chong Wu, Gongjun Xu and Wei Pan, "An Adaptive test on high dimensional parameters in generalized linear models" (Submitted)
}

