% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGLR_format.R
\name{BGLR_format}
\alias{BGLR_format}
\title{Format the phenotypic response matrix for BGLR}
\usage{
BGLR_format(Pheno, K)
}
\arguments{
\item{Pheno}{a data frame with three columns: "Y" for phenotypic values,
"Genotype" for genotype names and "Environment" for environment names.
All genotypes names must be included in the set or row/column names of
the "K" matrix. The number of environments (J) must be at least two}

\item{K}{a square kinship or genomic relationship matrix for N genotypes
whose row and column names include those of the "Genotype" column of
the "Pheno" matrix}
}
\value{
a list of two elements: a "BGLR_pheno" phenotypic response matrix
with J columns to be used in BGLR and the corresponding "BGLR_K" kinship matrix.
}
\description{
This function formats the phenotypic data as well as the kinship
matrix for BGLR
}
\examples{
## Set seed for reproductibility
set.seed(123)

## Load "wheat" dataset from BGLR
data("wheat",package = "BGLR")

## Generate a design data frame for all genotypes in 5 environments
Design <- expand.grid(Genotype=rownames(wheat.A),Environment=paste0("Env",1:5))

## Set sparseness by discarding 75\% of the combinations
Design <- Design[-sample(nrow(Design),round(nrow(Design)*3/4)),]

## Simulate phenotypic data with default parameter values
DataSim <- Simulate_MET_data(Design=Design,K=wheat.A)

## Generate the phenotypic response matrix for BGLR and the corresponding kinship matrix
BGLR_data <- BGLR_format(Pheno=DataSim$Pheno,K=wheat.A)
head(BGLR_data$BGLR_pheno)
}
