% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{Estimation}
\alias{Estimation}
\title{Estimating parameters along with corresponding variances based on the proposed model.}
\usage{
Estimation(
  ITER,
  MHiteration,
  eps,
  d,
  nSample,
  mm,
  time,
  MuxStar0,
  MuxInd0,
  SigmaxStar0,
  SigmaxInd0,
  Sigmav0,
  Sigmaw0,
  lambda0,
  sigma0,
  delta0,
  alpha0,
  beta10,
  beta20,
  beta30,
  beta40,
  InfPeriod,
  g
)
}
\arguments{
\item{ITER}{The number of simulation runs}

\item{MHiteration}{The number of iterations in Metropolis–Hastings algorithm}

\item{eps}{Stopping value for MCECM algorithm}

\item{d}{distance between cells}

\item{nSample}{number of sample in each cell}

\item{mm}{Number of areas.}

\item{time}{Maximum time.}

\item{MuxStar0}{Mean of unobserved areal level covariates.}

\item{MuxInd0}{Mean of unobserved individual level covariates.}

\item{SigmaxStar0}{Variance of unobserved areal level covariates.}

\item{SigmaxInd0}{Variance of unobserved individual level covariates.}

\item{Sigmav0}{Variance of areal level measurement error variable.}

\item{Sigmaw0}{Variance of individual level measurement error variable.}

\item{lambda0}{Spatial dependency parameter.}

\item{sigma0}{Over dispersion parameter.}

\item{delta0}{The spatial parameter.}

\item{alpha0}{Initial value for intercept.}

\item{beta10}{Initial value for coefficient of observed individual level covariates.}

\item{beta20}{Initial value for coefficient of observed areal level covariates.}

\item{beta30}{Initial value for coefficient of unobserved individual level covariates.}

\item{beta40}{Initial value for coefficient of unobserved areal level covariates.}

\item{InfPeriod}{The infectious period length.}

\item{g}{grid dimension}
}
\value{
the result of the function
}
\description{
Estimating parameters along with corresponding variances based on the proposed model.
}
\examples{
Estimation(1,5,0.05,2,4,4,20,0,0,1,1,0.3,0.3,0.5,0.5,2.5,0,1,1,1,
1,3,2)
}
