% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagnelie_vc22_1.R
\name{dagnelie_vc22_1}
\alias{dagnelie_vc22_1}
\title{Single-entry Dagnelie volume (tarif 1)}
\usage{
dagnelie_vc22_1(data, output = NULL)
}
\arguments{
\item{data}{A \code{data.frame} containing at least:
\itemize{
\item \code{c130}: stem circumference at 1.30 m (cm),
\item \code{species_code}: tree species code.
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
A \code{data.frame} identical to the input \code{data} but augmented with:
\itemize{
\item species-specific coefficients and validity ranges,
\item \code{dagnelie_vc22_1}: the computed Dagnelie tarif-1 volume (m\eqn{^3} per tree).
}
}
\description{
Computes the standing volume \eqn{v_{c,22}} (in cubic metres per tree) using
Dagnelie's single-entry tarif-1 equations.
The volume is derived from the stem circumference at 1.30 m (\code{c130}, in cm)
and the tree species, using species-specific polynomial coefficients stored
in the reference table \code{dan1}.
}
\details{
The tarif-1 volume is calculated as:
\deqn{
  v_{c,22} = coeff\_a + coeff\_b \cdot c130 + coeff\_c \cdot c130^2 + coeff\_d \cdot c130^3
}
where \eqn{a}, \eqn{b}, \eqn{c}, and \eqn{d} are species-specific coefficients.

The function performs the following steps:
\itemize{
\item checks that the input data frame contains the required
variables \code{c130} and \code{species_code},
\item validates that \code{c130} is numeric,
\item verifies that all species are available in the \code{dan1}
reference table and issues a warning otherwise,
\item merges the input with \code{dan1} to retrieve coefficients
and species-specific validity ranges (\code{min_c130}, \code{max_c130}),
\item warns when \code{c130} values fall outside the recommended range,
\item computes tarif-1 volume and returns the augmented data frame.
}

If one or more species codes are not found in \code{dan1}, the function issues
a warning and returns \code{NA}-values for missing coefficients and volumes.
Trees with \code{c130} values outside the recommended species-specific range
produce a warning but still receive a computed volume.
}
\section{Supported species}{

The following species codes are supported by \code{dagnelie_vc22_1}:
\itemize{
\item \code{"QUERCUS_SP"}
\item \code{"QUERCUS_ROBUR"}
\item \code{"QUERCUS_PETRAEA"}
\item \code{"QUERCUS_PUBESCENS"}
\item \code{"QUERCUS_RUBRA"}
\item \code{"FAGUS_SYLVATICA"}
\item \code{"ACER_PSEUDOPLATANUS"}
\item \code{"FRAXINUS_EXCELSIOR"}
\item \code{"ULMUS_SP"}
\item \code{"PRUNUS_AVIUM"}
\item \code{"BETULA_SP"}
\item \code{"ALNUS_GLUTINOSA"}
\item \code{"PICEA_ABIES"}
\item \code{"PSEUDOTSUGA_MENZIESII"}
\item \code{"LARIX_SP"}
\item \code{"PINUS_SYLVESTRIS"}
\item \code{"CRATAEGUS_SP"}
\item \code{"PRUNUS_SP"}
\item \code{"CARPINUS_SP"}
\item \code{"CASTANEA_SATIVA"}
\item \code{"CORYLUS_AVELLANA"}
\item \code{"MALUS_SP"}
\item \code{"PYRUS_SP"}
\item \code{"SORBUS_ARIA"}
\item \code{"SAMBUCUS_SP"}
\item \code{"RHAMNUS_FRANGULA"}
\item \code{"PRUNUS_CERASUS"}
\item \code{"ALNUS_INCANA"}
\item \code{"POPULUSxCANADENSIS"}
\item \code{"POPULUS_TREMULA"}
\item \code{"PINUS_NIGRA"}
\item \code{"PINUS_LARICIO"}
\item \code{"TAXUS_BACCATA"}
\item \code{"ACER_PLATANOIDES"}
\item \code{"ACER_CAMPESTRE"}
\item \code{"SORBUS_AUCUPARIA"}
\item \code{"JUNGLANS_SP"}
\item \code{"TILLIA_SP"}
\item \code{"PICEA_SITCHENSIS"}
\item \code{"ABIES_ALBA"}
\item \code{"TSUGA_CANADENSIS"}
\item \code{"ABIES_GRANDIS"}
\item \code{"CUPRESSUS_SP"}
\item \code{"THUJA_PLICATA"}
\item \code{"AESCULUS_HIPPOCASTANUM"}
\item \code{"ROBINIA_PSEUDOACACIA"}
\item \code{"SALIX_SP"}
}
}

\examples{
df <- data.frame(
  c130         = c(145, 156, 234, 233),
  species_code = c("PINUS_SYLVESTRIS", "QUERCUS_RUBRA",
                   "QUERCUS_SP", "FAGUS_SYLVATICA")
)
dagnelie_vc22_1(df)
}
\seealso{
\code{\link{dan1}} for species-specific coefficients.
}
