% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnn.fnc.R
\name{fnn.fnc}
\alias{fnn.fnc}
\title{Output of Estimated Functional Weights}
\usage{
fnn.fnc(model, domain_range, covariate_scaling = FALSE)
}
\arguments{
\item{model}{A keras model as outputted by \code{fnn.fit()}.}

\item{domain_range}{List of size k. Each element of the list is a 2-dimensional vector containing the upper and lower
bounds of the k-th functional weight. Must be the same covariates as input into \code{fnn.fit()}.}

\item{covariate_scaling}{If TRUE, then data will be internally scaled before model development.}
}
\value{
The following are returned:

\code{FNC_Coefficients} -- The estimated coefficients defining the basis expansion for each of the k functional weights.

\code{saved_plot} -- A list of size k of \code{ggplot()} objects.
}
\description{
This function outputs plots and \code{ggplot()} objects of the functional weights found by the \code{fnn.fit()} model.
}
\details{
No additional details for now.
}
\examples{
\donttest{
# libraries
library(fda)

# loading data
tecator = FuncNN::tecator

# define the time points on which the functional predictor is observed.
timepts = tecator$absorp.fdata$argvals

# define the fourier basis
nbasis = 29
spline_basis = create.fourier.basis(tecator$absorp.fdata$rangeval, nbasis)

# convert the functional predictor into a fda object and getting deriv
tecator_fd =  Data2fd(timepts, t(tecator$absorp.fdata$data), spline_basis)
tecator_deriv = deriv.fd(tecator_fd)
tecator_deriv2 = deriv.fd(tecator_deriv)

# Non functional covariate
tecator_scalar = data.frame(water = tecator$y$Water)

# Response
tecator_resp = tecator$y$Fat

# Getting data into right format
tecator_data = array(dim = c(nbasis, length(tecator_resp), 3))
tecator_data[,,1] = tecator_fd$coefs
tecator_data[,,2] = tecator_deriv$coefs
tecator_data[,,3] = tecator_deriv2$coefs

# Getting data ready to pass into function
ind = 1:165
tec_data_train <- array(dim = c(nbasis, length(ind), 3))
tec_data_train = tecator_data[, ind, ]
tecResp_train = tecator_resp[ind]
scalar_train = data.frame(tecator_scalar[ind,1])

# Setting up network
tecator_fnn = fnn.fit(resp = tecResp_train,
                      func_cov = tec_data_train,
                      scalar_cov = scalar_train,
                      basis_choice = c("fourier", "fourier", "fourier"),
                      num_basis = c(5, 5, 7),
                      hidden_layers = 4,
                      neurons_per_layer = c(64, 64, 64, 64),
                      activations_in_layers = c("relu", "relu", "relu", "linear"),
                      domain_range = list(c(850, 1050), c(850, 1050), c(850, 1050)),
                      epochs = 300,
                      learn_rate = 0.002)

# Functional weights for this model
est_func_weights = fnn.fnc(tecator_fnn, domain_range = list(c(850, 1050),
                                                            c(850, 1050),
                                                            c(850, 1050)))
}

}
