% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapeData.R
\name{freqprof}
\alias{freqprof}
\title{Convert data to moving sum/prop.}
\usage{
freqprof(data.behavior, window = round(0.25 * nrow(data.behavior)),
  step = 1, resolution = 1, which = c("sum", "proportion"))
}
\arguments{
\item{data.behavior}{a data.frame containing occurrence/nonoccurrence data in
binary (0/1) format}

\item{window}{the window length to use in computing a moving sum or
proportion}

\item{step}{the number of bins of which the data will be translated.}

\item{resolution}{the number of points contained in a bin}

\item{which}{giving the moving function to apply: sum or proportion}
}
\value{
The data in a \code{freqprof} object.
}
\description{
Convert data to moving sum/prop.
}
\examples{
data(s58)
freqprof(s58)
}

