% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrugFormulation.R
\name{regression_analysis}
\alias{regression_analysis}
\title{Perform regression analysis}
\usage{
regression_analysis(formulation_data)
}
\arguments{
\item{formulation_data}{A data frame containing the formulation data.}
}
\value{
A summary of the regression analysis results.
}
\description{
This function conducts regression analysis to model relationships between formulation parameters and response variables.
}
\examples{
formulation_data <- data.frame(
  Excipient_Concentration = runif(100, min = 0, max = 1),
  Drug_Release = rnorm(100, mean = 50, sd = 10),
  Particle_Size = rnorm(100, mean = 100, sd = 20)
)
regression_analysis(formulation_data)
}
