% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_generic_methods.R
\name{summary_fe_species}
\alias{summary_fe_species}
\title{Generic Summary for \strong{fe_species} Objects}
\usage{
summary_fe_species(
  x,
  spec_lang = c("code", "eng", "ger", "sci"),
  maxsum = 100L
)
}
\arguments{
\item{x}{Object of one of the supported \code{fe_species_} classes}

\item{spec_lang}{Choice of how species (group) names or id's are displayed.
Supported choices are "code" (default, displays the species codes as they
are), "eng" (English species names), "ger" (German species names), and
"sci" (scientific species names). The names and the codes refer to the
species coding given in the object's attribute \code{species_coding}.}

\item{maxsum}{Same as parameter \code{maxsum} in \code{\link{summary.factor}}}
}
\value{
A named vector in the same style as returned by
\code{\link{summary.factor}}
}
\description{
Produces a summary for a fe_species object in the same style as R does
factors. Actually, after some conversions \code{\link{summary.factor}} \emph{is}
called by this function. The species naming in the summary depends on the
parameter \code{spec_lang}.
}
\keyword{internal}
