% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flget_climatology.R
\name{flget_climatology}
\alias{flget_climatology}
\title{Extract climatology data from a NetCDF file downloaded by \code{FjordLight}.}
\usage{
flget_climatology(
  fjord,
  optics = "PARbottom",
  period = "Global",
  month = NULL,
  year = NULL,
  mode = "raster",
  PLOT = FALSE
)
}
\arguments{
\item{fjord}{Expects the object loaded via \code{\link{fl_LoadFjord}}.}

\item{optics}{The PAR variable that the user would like to load. The option are:
\code{"PARbottom"} (default) to load the bottom PAR values, \code{"PAR0m"} surface PAR,
or \code{"Kpar"} for the extinction coefficient.}

\item{period}{Here the user determines which time period of data should be loaded. To load
the total average values (default) use \code{"Global"}. One may chose instead to load the
\code{"Yearly"} or \code{"Monthly"} values. Note that monthly values here represent the
climatological average for the month, not one month in a given year. If the user would
like one specific month of data (only available for bottom PAR), they should use
\code{\link{flget_PARbottomMonthlyTS}}.}

\item{month}{The monthly climatology to extract. Accepts an integer value from 3 to 10.
This argument is ignored if \code{period = "Yearly"}.}

\item{year}{The yearly average to extract. Currently accepts an integer value from 2003 to 2022.
This argument is ignored if \code{period = "Monthly"}.}

\item{mode}{Determines the format of the data loaded into the R environment.
The default \code{"raster"} will load the data as a raster format. The other option \code{"df"}
will load the data as a data.frame with three columns.}

\item{PLOT}{Boolean argument (default = \code{FALSE}) that tells the function if the user
would like the loaded data to be plotted or not.}
}
\value{
Depending on which arguments the user chooses, this function will return the
chosen, global, annual, or monthly climatology data as a \code{RasterLayer}
(\code{mode = "raster"}) or data.frame (\code{mode = "df"}).
The data.frame will contain the following columns:
  \item{longitude}{degree decimals}
  \item{latitude}{degree decimals}
  \item{optics_month|year}{The column name is determined by the arguments for
  \code{optics} and either \code{month} or \code{year}, depending on the users choice.}
}
\description{
This functions will conveniently extract the climatology data stored within a
NetCDF file downloaded via \code{\link{fl_DownloadFjord}}. To extract the monthly
bottom PAR data instead one must use \code{\link{flget_PARbottomMonthlyTS}}.
There are options for how the user would like to subset the data, which data format the
data should be extracted to, and if the user would like to plot the data in the process.
}
\examples{
# Load data
fjord_code <- "test"
fjorddata <- fl_LoadFjord(fjord_code, dirdata = system.file("extdata", package = "FjordLight"))

# PAR0m and PARbottom for July
\donttest{
P07 <- flget_climatology(fjorddata, "PAR0m", "Clim", month = 7, PLOT = TRUE)
Pb7 <- flget_climatology(fjorddata, "PARbottom", "Clim", month = 7, PLOT = TRUE)
}

# PARbottom Global
\donttest{
PbG <- flget_climatology(fjorddata, "PARbottom", "Global", PLOT = TRUE)
}

# PAR0m and kdpar for year 2012 as 3 columns data frame
P02012 <- flget_climatology(fjorddata, "PAR0m", "Yearly", year = 2012, mode = "df")
k2012 <- flget_climatology(fjorddata, "Kpar", "Yearly", year = 2012, mode = "df")

# For more examples see: https://face-it-project.github.io/FjordLight/articles/fl_example.html

}
\author{
Bernard Gentili
}
