% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01.firm_query.R
\name{query.firms}
\alias{query.firms}
\title{Function to extract information from multiple \code{firm} object (legal person)}
\usage{
query.firms(..., which, naming = TRUE)
}
\arguments{
\item{...}{Object/s which to extract information from (see 'Details')}

\item{which}{Information to extract, minimum unambiguous sub-string. Possible values (one or more):
- \code{name} Name of the firm
- \code{id} ID of the firm, usually the ticker (if provided or otherwise known)
- \code{legal_form} Legal form of the firm
- \code{sector} Sector in which the firm operates
- \code{revenues} Yearly revenues
- \code{capitalisation} Capitalisation
- \code{management} Members of the board
- \code{ownership} Owner(s)
- \code{shares} Share owned by (each of) the owner(s)
- \code{currency} Currency in which revenues and capitalisation are denominated}

\item{naming}{Whether to name the result after the querie information (defaults to \code{TRUE})}
}
\value{
Depends on the information queried. An object of class \code{\link{list}} (that, if \code{length(which)>=2}, contain multiple sub-lists) of the following:
\item{name}{A string representing the name of the firm}
\item{id}{A string representing the ID of the firm (usually its ticker)}
\item{legal_form}{A string representing the firm's legal form}
\item{sector}{A string indicating the sector in which the firm operates (possibly a NACE rev. 2 code)}
\item{revenues}{A numeric (double) quantifying yearly revenues}
\item{capitalisation}{A numeric (double) quantifying capitalisation}
\item{management}{A vector of strings representing the members of the board}
\item{ownership}{A vector of strings representing the owner(s)}
\item{shares}{A numeric (double) vector indicating the shares controlled by (each of) the owner(s)}
\item{currency}{A string indicating the currency in which revenues and capitalisation are denominated}
}
\description{
This function can be fed either:
- a (possibly named) \code{\link{list}} of objects of class \code{firm} (see examples 1 and 2); or
- multiple objects of class \code{firm}(see example 3)
}
\examples{
\donttest{
# Query Apple's, GM's, and BTI's market cap and revenues
data('firms_US')
query.firms(firms_US, which = c('cap', 'rev'))

# Query GM's and BTI's management
data('firms_US')
query.firms(firms_US, which = 'man')

# Query Appple's and GM's revenues and currency
data('firms_US')
list2env(firms_US, envir = parent.frame())
query.firms(AAPL, GM, which = c('rev', 'curr'))
}

}
\seealso{
\link{query.firm} \link{query.firms.dataframe}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
