% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spelling.R
\name{splitCamel}
\alias{splitCamel}
\alias{splitPascal}
\title{Split CamelCase or PascalCase Strings}
\source{
<stackoverflow.com/questions/8406974/splitting-camelcase-in-r>
}
\usage{
splitCamel(x, conseq = TRUE)

splitPascal(x, conseq = TRUE)
}
\arguments{
\item{x}{A character vector containing CamelCase or PascalCase strings to
be split.}

\item{conseq}{Logical indicating whether consecutive uppercase letters should
be treated as part of the previous word (TRUE) or as separate words
(FALSE). Default is TRUE.}
}
\value{
A list of character vectors, each containing the parts of the
corresponding CamelCase or PascalCase string split at the appropriate
transitions. If \code{conseq} is FALSE, acronyms followed by words are
separated.
}
\description{
This function splits strings formatted in camelCase or PascalCase into their
component words. It can handle words where uppercase letters transition to
lowercase letters, and it is capable of handling strings with sequences of
uppercase letters followed by lowercase letters, effectively separating
acronyms from camelCase beginnings.
}
\examples{
splitCamel("splitCamelCaseIntoWords")
splitCamel(c("fooBar", "FOOBar", "anotherFOOBarTest"), conseq = FALSE)

}
\keyword{spelling}
