% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_assessment.R
\name{love_plot}
\alias{love_plot}
\title{Love plot}
\usage{
love_plot(
  data_frame,
  index_col = TRUE,
  alloc1,
  alloc2 = NULL,
  imbalance = "TASMD",
  treat_lab = 1,
  vline = "",
  xupper = 1,
  mean_tar = NULL,
  sd_tar = NULL,
  denom = "target",
  legend_text = "FSM",
  legend_position = "topright"
)
}
\arguments{
\item{data_frame}{Data frame containing a column of unit indices (optional) and covariates (or transformations thereof).}

\item{index_col}{if \code{TRUE}, \code{data_frame} contains a column of unit indices.}

\item{alloc1}{A vector of treatment assignment.}

\item{alloc2}{A (optional) vector of treatment assignment.}

\item{imbalance}{Measure of imbalance used. If \code{imbalance = 'TASMD'}, imbalance is computed using 
the Target Absolute Standardized Mean Differences (TASMD). If \code{imbalance = 'ASMD'}, 
imbalance is computed using the Absolute Standardized Mean Differences (ASMD)}

\item{treat_lab}{Label of the treatment group in which the TASMD is computed. Applicable only when \code{imbalance = 'TASMD'}.}

\item{vline}{A (optional) x-coordinate at which a vertical line is drawn.}

\item{xupper}{Upper limit of the x-axis.}

\item{mean_tar}{A (optional) vector of target profile of the covariates under consideration, 
e.g., mean of the covariates in the target population. Applicable only when \code{imbalance = 'TASMD'}. 
If \code{mean_tar = NULL}, the full-sample average of the covariates is considered as the target profile.}

\item{sd_tar}{A optional vector of the standard deviation of the covariates in the target population. 
Applicable only when \code{imbalance = 'TASMD'}.}

\item{denom}{Specifies the denominator for the computation of TASMD. If \code{denom = 'target'}, 
the standard deviations of the covariates in the target population are used. If \code{denom = 'group'}, 
the standard deviations of the covariates in the treatment group given by \code{treat_lab} are used. 
Applicable only when \code{imbalance = 'TASMD'}.}

\item{legend_text}{Legend of the two designs under consideration.}

\item{legend_position}{= Position of the legend in the plot. The default is \code{'topright'}.}
}
\value{
Love plot of the ASMD/TASMD of the covariates.
}
\description{
Generates a Love plot of Absolute Standardized Mean Differences (ASMD) or Target Absolute Standardized Differences (TASMD) 
between two groups under one or two designs.
}
\examples{
# Consider the Lalonde dataset.
# Get the full sample size.
N = nrow(Lalonde)
# Get the treatment group sizes.
n1 = floor(N/2)
n2 = N-n1
# Generate an SOM.
som_obs = som(n_treat = 2, treat_sizes = c(n1,n2),include_discard = FALSE,
method = 'SCOMARS', marginal_treat = rep((n2/N),N), control = FALSE)
# Generate a treatment assignment given som_obs.
f = fsm(data_frame = Lalonde, SOM = som_obs, s_function = 'Dopt', eps = 0.0001, 
ties = 'random', intercept = TRUE, standardize = TRUE, units_print = FALSE)
# Get assignment vector under the FSM.
Z_fsm_obs = f$data_frame_allocated$Treat
# Draw a random CRD.
Z_crd_obs = crd(data_frame = Lalonde, n_treat = 2, treat_sizes = c(n1, n2), 
control = FALSE)$Treat
# Draw Love plot.
love_plot(data_frame = Lalonde, index_col = TRUE, alloc1 = Z_fsm_obs, alloc2 = Z_crd_obs, 
imbalance = 'TASMD', treat_lab = 1, mean_tar = NULL, sd_tar = NULL, denom = 'target',
vline = "", legend_text = c("FSM","CRD"), xupper = 0.15, legend_position = 'topright') 
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), ``Randomized and Balanced Allocation 
of Units into Treatment Groups Using the Finite Selection Model for \code{R}".

Love, T. (2004), “Graphical display of covariate balance”, Presentation, 
See http://chrp.org/love/JSM2004RoundTableHandout.pdf, 1364.
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
