library(FMM)

test_that("Parameter values in correct range.",{
  mouseGeneExpFit <- fitFMM(mouseGeneExp, nback = 2)
  expect_gte(mouseGeneExpFit@A[1], 0)
  expect_gte(mouseGeneExpFit@A[2], 0)
  expect_gte(mouseGeneExpFit@alpha[1], 0)
  expect_gte(mouseGeneExpFit@alpha[2], 0)
  expect_gte(mouseGeneExpFit@omega[1], 0)
  expect_gte(mouseGeneExpFit@omega[2], 0)
  expect_gte(mouseGeneExpFit@beta[1], 0)
  expect_gte(mouseGeneExpFit@beta[2], 0)
  expect_lte(mouseGeneExpFit@alpha[1], 2*pi)
  expect_lte(mouseGeneExpFit@alpha[2], 2*pi)
  expect_lte(mouseGeneExpFit@omega[1], 2*pi)
  expect_lte(mouseGeneExpFit@omega[2], 2*pi)
  expect_lte(mouseGeneExpFit@beta[1], 2*pi)
  expect_lte(mouseGeneExpFit@beta[2], 2*pi)
})

test_that("Returns an S4 class object (FMM object).",{
  expect_s4_class(fitFMM(mouseGeneExp, nback = 2), "FMM")
  expect_s4_class(fitFMM(neuronalAPTrain, nback = 6), "FMM")
  expect_s4_class(fitFMM(neuronalSpike, nback = 2), "FMM")
})

test_that("Correct length of each vector slot.",{
  mouseGeneExpFit <- fitFMM(mouseGeneExp, nback = 2)
  neuronalAPTrainFit <- fitFMM(neuronalAPTrain, nback = 6)
  neuronalSpikeFit <- fitFMM(neuronalSpike, nback = 2)
  expect_length(mouseGeneExpFit@A, 2)
  expect_length(mouseGeneExpFit@alpha, 2)
  expect_length(mouseGeneExpFit@beta, 2)
  expect_length(mouseGeneExpFit@omega, 2)
  expect_length(mouseGeneExpFit@M, 1)
  expect_length(mouseGeneExpFit@timePoints, length(mouseGeneExp))
  expect_length(mouseGeneExpFit@fittedValues, length(mouseGeneExp))
  expect_length(mouseGeneExpFit@data, length(mouseGeneExp))
  expect_length(neuronalAPTrainFit@A, 6)
  expect_length(neuronalAPTrainFit@alpha, 6)
  expect_length(neuronalAPTrainFit@beta, 6)
  expect_length(neuronalAPTrainFit@omega, 6)
  expect_length(neuronalAPTrainFit@M, 1)
  expect_length(neuronalAPTrainFit@timePoints, length(neuronalAPTrain))
  expect_length(neuronalAPTrainFit@fittedValues, length(neuronalAPTrain))
  expect_length(neuronalAPTrainFit@data, length(neuronalAPTrain))
  expect_length(neuronalSpikeFit@A, 2)
  expect_length(neuronalSpikeFit@alpha, 2)
  expect_length(neuronalSpikeFit@beta, 2)
  expect_length(neuronalSpikeFit@omega, 2)
  expect_length(neuronalSpikeFit@M, 1)
  expect_length(neuronalSpikeFit@timePoints, length(neuronalSpike))
  expect_length(neuronalSpikeFit@fittedValues, length(neuronalSpike))
  expect_length(neuronalSpikeFit@data, length(neuronalSpike))
})

test_that("FMM fit in limit parameter values simulated data.",{
  tmpData <- generateFMM(0, A = c(1, 1), alpha = c(0, pi), beta = c(pi/2, 3*pi/2), omega = c(0.05, 0.05),
                         length.out = 50, plot = F)$y
  tmpDataFit <- fitFMM(tmpData, nback = 2)
  expect_gte(tmpDataFit@A[1], 0)
  expect_gte(tmpDataFit@A[2], 0)
  expect_gte(tmpDataFit@alpha[1], 0)
  expect_gte(tmpDataFit@alpha[2], 0)
  expect_gte(tmpDataFit@omega[1], 0)
  expect_gte(tmpDataFit@omega[2], 0)
  expect_gte(tmpDataFit@beta[1], 0)
  expect_gte(tmpDataFit@beta[2], 0)
  expect_lte(tmpDataFit@alpha[1], 2*pi)
  expect_lte(tmpDataFit@alpha[2], 2*pi)
  expect_lte(tmpDataFit@omega[1], 2*pi)
  expect_lte(tmpDataFit@omega[2], 2*pi)
  expect_lte(tmpDataFit@beta[1], 2*pi)
  expect_lte(tmpDataFit@beta[2], 2*pi)
  expect_length(tmpDataFit@M, 1)
  expect_length(tmpDataFit@A, 2)
  expect_length(tmpDataFit@alpha, 2)
  expect_length(tmpDataFit@beta, 2)
  expect_length(tmpDataFit@omega, 2)
  expect_length(tmpDataFit@timePoints, length(tmpData))
  expect_length(tmpDataFit@fittedValues, length(tmpData))
  expect_length(tmpDataFit@data, length(tmpData))
  expect_s4_class(tmpDataFit, "FMM")

  tmpData2 <- generateFMM(0, A = c(1, 1), alpha = c(0, pi), beta = c(0,pi),
                         omega = c(0.95, 0.05), length.out = 50, plot = F)$y
  tmpDataFit2 <- fitFMM(tmpData2, nback = 2)
  expect_gte(tmpDataFit2@A[1], 0)
  expect_gte(tmpDataFit2@A[2], 0)
  expect_gte(tmpDataFit2@alpha[1], 0)
  expect_gte(tmpDataFit2@alpha[2], 0)
  expect_gte(tmpDataFit2@omega[1], 0)
  expect_gte(tmpDataFit2@omega[2], 0)
  expect_gte(tmpDataFit2@beta[1], 0)
  expect_gte(tmpDataFit2@beta[2], 0)
  expect_lte(tmpDataFit2@alpha[1], 2*pi)
  expect_lte(tmpDataFit2@alpha[2], 2*pi)
  expect_lte(tmpDataFit2@omega[1], 2*pi)
  expect_lte(tmpDataFit2@omega[2], 2*pi)
  expect_lte(tmpDataFit2@beta[1], 2*pi)
  expect_lte(tmpDataFit2@beta[2], 2*pi)
  expect_length(tmpDataFit2@M, 1)
  expect_length(tmpDataFit2@A, 2)
  expect_length(tmpDataFit2@alpha, 2)
  expect_length(tmpDataFit2@beta, 2)
  expect_length(tmpDataFit2@omega, 2)
  expect_length(tmpDataFit2@timePoints, length(tmpData2))
  expect_length(tmpDataFit2@fittedValues, length(tmpData2))
  expect_length(tmpDataFit2@data, length(tmpData2))
  expect_s4_class(tmpDataFit2, "FMM")
})


