% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamExpandEM.R
\name{beamExpandEM}
\alias{beamExpandEM}
\title{beamExpandEM}
\usage{
beamExpandEM(beamP, beamT, ElementMat)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{ElementMat}{Element stiffness matrix list.}
}
\value{
produces large (n x n) element matrix from initial element matrix.
\item{beamExMat}{The expanded element matrix}
}
\description{
Expanded element matrix for beam.
}
\examples{
data(beamGeo)
data(beamEmat)

ElementMat = beamEmat
beamExMat =  beamExpandEM(beamGeo$beamP, beamGeo$beamT, ElementMat)

}
