% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamElementMat.R
\name{beamElementMat}
\alias{beamElementMat}
\title{beamElementMat}
\usage{
beamElementMat(beamP, beamT, Y, Length, MoI)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{Y}{Elastic modulus value for material.}

\item{Length}{Length of beams.}

\item{MoI}{Moment of inertia for each beam segment.}
}
\value{
Generates initial element matrix needed for the finite element model.
\item{beamEmat}{An element matrix of the beam}
}
\description{
Generates element stiffness matrix for beams.
}
\examples{
data(beamGeo)
data(beamDime)

Length = beamDime$Length
MoI = beamDime$MomentofInertia

beamEmat = beamElementMat(beamGeo$beamP, beamGeo$beamT, beamGeo$Y, Length, MoI)

}
