% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpandSFT.2d.R
\name{ExpandSFT.2d}
\alias{ExpandSFT.2d}
\title{ExpandSFT.2d}
\usage{
ExpandSFT.2d(meshP, meshT, SurfTrac)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{meshT}{Matrix (3 x n) containing the number of the coordinate point that forms a given triangle within the mesh.}

\item{SurfTrac}{List of surface forces.}
}
\value{
Produces a large (n x n) element matrix of surface forces.
\item{ExpandedSurf}{Expanded surface force element matrix.}
}
\description{
Generates expanded surface force element matrix from SurfaceTraction function
}
\examples{
data(triMesh)
data(SurfTrac)

meshT = triMesh$MeshPts$T
meshP = triMesh$MeshPts$p

expSurf = ExpandSFT.2d(meshP, meshT, SurfTrac)

}
