% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dimensions.2d.R
\name{Dimensions.2d}
\alias{Dimensions.2d}
\title{Dimensions.2d}
\usage{
Dimensions.2d(meshP, meshT, centroid)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{meshT}{Matrix (3 x n) containing the number of the coordinate point that forms a given triangle within the mesh.}

\item{centroid}{Matrix (2 x n) containing coordinate points of the centroid of each triangular element.}
}
\value{
Evaluation of triangle elements truss, angle, and area.
\item{Truss}{Nodal pairs that form each truss.}
\item{TrussLength}{Distance between each paired nodes forming a truss, its length.}
\item{Dist2Cent}{Shortest distance from truss to triangle centroid.}
\item{Truss angle}{Angles of the triangle created from truss meeting.}
\item{AspectRatio}{Aspect ratio of triangle elements.}
\item{Area}{Area within triangle elements.}
}
\description{
Calculates dimensional values for each triangular element, including truss length & angles, distance from nodal point to centroid, aspect ratio of each triangle element, and area of the triangle.
}
\examples{
data(triMesh)
data(polyshape)

meshP = triMesh$MeshPts$p
meshT = triMesh$MeshPts$T
centroid = triMesh$Centroids

dime = Dimensions.2d(meshP, meshT, centroid)

}
