% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pi0.R
\name{get.pi0}
\alias{get.pi0}
\title{pi0 Estimation}
\usage{
get.pi0(
  pvalues,
  set.pi0 = 1,
  zvalues = "two.sided",
  estim.method = "last.hist",
  threshold = 0.05,
  default.odds = 1,
  hist.breaks = "scott",
  na.rm = TRUE
)
}
\arguments{
\item{pvalues}{A numeric vector of raw p-values.}

\item{set.pi0}{A numeric value to specify a known or assumed pi0 value in the interval \code{[0,1]}. Defaults to 1. Which means the assumption is that all inputted raw p-values come from the null distribution.}

\item{zvalues}{A numeric vector of z-values to be used in pi0 estimation or a string with options "two.sided", "greater" or "less". Defaults to "two.sided".}

\item{estim.method}{A string used to determine which method is used to estimate the pi0 value. Defaults to "last.hist".}

\item{threshold}{A numeric value in the interval \code{[0,1]} used in a multiple comparison hypothesis tests to determine significance from the null. Defaults to 0.05.}

\item{default.odds}{A numeric value determining the ratio of pi1/pi0 used in the computation of lower bound FDR. Defaults to 1.}

\item{hist.breaks}{A numeric or string variable representing how many breaks in the pi0 estimation histogram methods. Defaults to "scott".}

\item{na.rm}{A Boolean TRUE or FALSE value indicating whether NA's should be removed from the inputted raw p-value vector before further computation. Defaults to TRUE.}
}
\value{
An estimated null proportion:

\item{pi0}{A numeric value representing the proportion of the given data that come from the null distribution. A value in the interval \code{[0,1]}.}
}
\description{
This function estimates the null proportion of data or pi0 value.
}
\details{
We run into errors or warnings when pvalues, zvalues, threshold or default.odds are not inputted correctly.
}
\examples{

# Example 1
pi0 = 0.8
pi1 = 1-pi0
n = 10000
n.0 = ceiling(n*pi0)
n.1 = n-n.0

sim.data = c(rnorm(n.1,3,1),rnorm(n.0,0,1))
sim.data.p = 2*pnorm(-abs(sim.data))

get.pi0(sim.data.p, estim.method = "last.hist")
get.pi0(sim.data.p, estim.method = "storey")
get.pi0(sim.data.p, estim.method = "set.pi0")

}
\references{
\insertRef{Rpack:bibtex}{Rdpack}

\insertRef{R}{FDRestimation}

\insertRef{storey:2003}{FDRestimation}

\insertRef{mein:2006}{FDRestimation}

\insertRef{jiang:2008}{FDRestimation}

\insertRef{nett:2006}{FDRestimation}

\insertRef{pounds:2003}{FDRestimation}

\insertRef{murray2020false}{FDRestimation}
}
\seealso{
\code{\link{plot.p.fdr}, \link{p.fdr}, \link{summary.p.fdr}}
}
\concept{FDR adjusted p-values null proportion}
\keyword{FDR}
\keyword{p-values}
