% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_matrix_lp.R
\name{cost_matrix_lp}
\alias{cost_matrix_lp}
\title{Cost Matrix of \eqn{\ell^p}{l^p}-Form.}
\usage{
cost_matrix_lp(x, y = NULL, p = 2, q = 1)
}
\arguments{
\item{x}{matrix of size \eqn{n \times d} containing vectors \eqn{x_1, \ldots, x_n \in \mathbb{R}^d} (row-wise).}

\item{y}{matrix of size \eqn{m \times d} containing vectors \eqn{y_1, \ldots, y_m \in \mathbb{R}^d} (row-wise); \code{y = NULL} means that \eqn{y_i = x_i}.}

\item{p}{number \eqn{p \in (0, \infty]}.}

\item{q}{number \eqn{q \in (0, \infty)}.}
}
\value{
A \eqn{n \times m} matrix with entry at \eqn{i, j} being equal to
\deqn{
 \lVert x_i - y_j \rVert_p^q = \left[ \sum_{k=1}^d \lvert x_{i,k} - y_{j, k} \rvert^p \right]^{q/p}
}
For \code{p = Inf}, this is to be understood as the maximum norm to the power of \eqn{q}.
}
\description{
Compute cost matrices of \eqn{\ell^p}-form.
}
\examples{
n <- 3
m <- 4
d <- 5
x <- runif(n * d) |> matrix(n, d)
y <- runif(m * d) |> matrix(m, d)
costm <- cost_matrix_lp(x, y)
print(costm)
}
