% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{mjmcmc.parallel}
\alias{mjmcmc.parallel}
\title{Run Multiple MJMCMC Runs in Parallel, Merging the Results Before Returning.}
\usage{
mjmcmc.parallel(runs = 2, cores = getOption("mc.cores", 2L), ...)
}
\arguments{
\item{runs}{The number of runs to run}

\item{cores}{The number of cores to run on}

\item{...}{Further parameters passed to mjmcmc.}
}
\value{
Merged results from multiple mjmcmc runs
}
\description{
Run Multiple MJMCMC Runs in Parallel, Merging the Results Before Returning.
}
\examples{
result <- mjmcmc.parallel(runs = 1, 
cores = 1, 
loglik.pi = FBMS::gaussian.loglik,
y = matrix(rnorm(100), 100),
x = matrix(rnorm(600), 100))
summary(result)
plot(result)

}
