% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.R
\name{coef.gmjmcmc_merged}
\alias{coef.gmjmcmc_merged}
\title{Coefficients for GMJMCMC Merged Model}
\usage{
\method{coef}{gmjmcmc_merged}(object, ...)
}
\arguments{
\item{object}{Object of class "gmjmcmc_merged".}

\item{...}{Additional arguments (ignored).}
}
\value{
Vector of coefficients from the best model found.
}
\description{
Extracts coefficients from the best GMJMCMC merged model.
}
\examples{
data(exoplanet)
model <- fbms(semimajoraxis ~ ., data = exoplanet, 
method = "gmjmcmc.parallel", transforms = c("sigmoid"), 
runs = 2, cores = 1)
coef(model)
}
