#' Temporal microbiome composition data
#'
#' A subset of the data generated by Xue et al. (2024) detailing longitudinal
#' composition of the human gut microbiome for three subjects who experience an
#' antiobitic perturbation between days 29 and 34. We include only the subjects
#' XAA, XBA, and XCA. Data from \doi{10.1101/2023.09.26.559480}.
#'
#' @format ## `xue_microbiome_sample`
#' A data frame with 75 rows and 1,348 columns:
#' \describe{
#'   \item{subject}{Subject ID: XBA, XDA, or XMA}
#'   \item{timepoint}{Time (days) of sample collection}
#'   \item{...}{Species names}
#'   ...
#' }
"xue_microbiome_sample"



#' Phylogenetic tree for the species included in xue_microbiome_sample
#'
#' A phylogenetic tree in the Newick format.
#'
#' @format ## `xue_species_tree`
#' A Newick tree.
"xue_species_tree"

#' Species similarity matrix for the species included in xue_microbiome_sample
#'
#' A similarity matrix, with entry (i,j) corresponding to the pairwise similarity
#' between species i and species j. This similarity matrix was derived from a
#' phylogenetic distance matrix, inferred from the tree xue_species_tree,
#' using the expression s(i,j) = exp(-d(i,j)), where d(i,j) is the phylogenetic
#' distance between species i and j.
#'
#' @format ## `xue_species_similarity`
#' A data frame with 524 rows and 524 columns, each corresponding to one species.
"xue_species_similarity"


#' Table of species information
#'
#' A data frame providing taxonomic information for the species included in xue_species_tree.
#'
#' @format ## `xue_species_info`
#' A data frame with 1346 rows and 9 columns:
#' \describe{
#'   \item{species_id}{The species_id given in xue_microbiome_sample}
#'   \item{kingdom, phylum, class, order, family, genus, species}{The corresponding taxonomic category for each species}
#'   \item{species_id_number}{The numeric code associated with each species, as used in xue_species_tree}
#' }
"xue_species_info"



