% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{SunHA}
\alias{SunHA}
\title{Sunset Hour Angel (omega_s)}
\usage{
SunHA(phi, delta)
}
\arguments{
\item{phi}{A numeric scalar that denotes the latitude [rad].}

\item{delta}{A numeric scalar that denotes the solar declination [rad].}
}
\value{
The function returns the value of sunset hour angel as a numeric scalar.
}
\description{
\code{SunHA} returns the value of sunset hour angel [rad].
}
\details{
This is a function to calculate the sunset hour angel.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
SunHA(phi = -0.35, delta = 0.12)

}
\seealso{
\code{\link{SolDec}}.
}
