% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{backtest_all}
\alias{backtest_all}
\title{Exact UC/IND/CC back‑tests in one call}
\usage{
backtest_all(x, alpha = 0.05, sig = 0.05, prune_threshold = 1e-15)
}
\arguments{
\item{x}{0/1 exception series.}

\item{alpha}{Exception probability.}

\item{sig}{Significance level (default \code{0.05}).}

\item{prune_threshold}{Passed to the dynamic programming engine.}
}
\value{
An object of class \code{"ExactVaRBacktestAll"} (a named list) with components:
\code{uc}, \code{ind}, \code{cc} (each a list with \code{stat}, \code{pval}, \code{reject}),
and scalars \code{sig} (significance level), \code{alpha} (model exception probability),
\code{n} (sample size).
}
\description{
Exact UC/IND/CC back‑tests in one call
}
\examples{
set.seed(1)
x <- rbinom(300, 1, 0.02)
backtest_all(x, alpha = 0.02)
}
