% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designCheck.R
\name{designCheck}
\alias{designCheck}
\title{designCheck}
\usage{
designCheck(DATA, DESIGN = NULL, make_design_nominal = TRUE)
}
\arguments{
\item{DATA}{original data that should be matched to a design matrix}

\item{DESIGN}{a column vector with levels for observations or a dummy-coded
matrix}

\item{make_design_nominal}{a boolean. Will make DESIGN nominal if TRUE
(default).}
}
\value{
\item{DESIGN}{dummy-coded design matrix}
}
\description{
Checks and/or creates a dummy-coded design matrix.
}
\details{
Returns a properly formatted, dummy-coded (or disjunctive coding) design
matrix.
}
\examples{

	data <- iris[,c(1:4)]
	design <- as.matrix(iris[,c('Species')])
	iris.design <- designCheck(data,DESIGN=design,make_design_nominal=TRUE)

}
\author{
Derek Beaton
}
\keyword{misc}
