% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_procedure.R
\name{test_procedure}
\alias{test_procedure}
\title{Function to provide summary and test statistics based on simulation.}
\usage{
test_procedure(
  pilevel = 0.9,
  nyears = 4,
  enroll_fit = enroll_fit,
  dropout_fit = dropout_fit,
  enroll_prior = NULL,
  event_prior_h0 = NULL,
  event_prior_ha = NULL,
  dropout_prior = NULL,
  target_n,
  target_IA_d,
  target_d,
  ialpha = 0.025,
  falpha,
  lag,
  by_fitted_enroll = FALSE,
  by_fitted_dropout = FALSE,
  treatment_label,
  ngroups = 2,
  alloc = NULL,
  nreps = 500,
  IA_included,
  test = "Superiority",
  test_IA = "Superiority",
  Futility_boundary = 1,
  seed.num = NULL
)
}
\arguments{
\item{pilevel}{the confidence interval, the default is 0.95.}

\item{nyears}{the year after data cutoff or follow-up.}

\item{enroll_fit}{an object generated from \code{fitEnrollment}.}

\item{dropout_fit}{an object generated from \code{fitDropout}.}

\item{enroll_prior}{The prior of enrollment model parameters.}

\item{event_prior_h0}{The prior of event model parameters under null hypothesis}

\item{event_prior_ha}{The prior of event model parameters under alternative hypothesis}

\item{dropout_prior}{The prior of dropout model parameters.}

\item{target_n}{The target number of subjects to enroll in the study.}

\item{target_IA_d}{number of events needed for interim analysis}

\item{target_d}{number of events needed for primary analysis}

\item{ialpha}{interim analysis alpha nominal value (only one interim allowed)}

\item{falpha}{primary analysis alpha nominal value}

\item{lag}{a scalar to denote time (days). Hazard ratio before and after this time would be calculated.}

\item{by_fitted_enroll}{A Boolean variable to control whether or not to
predict enrollment time with fitted model. By default, it is set to \code{FALSE}.}

\item{by_fitted_dropout}{A Boolean variable to control whether or not to
predict dropout time with fitted model. By default, it is set to \code{FALSE}.}

\item{treatment_label}{The treatment labels for treatments in a
randomization block for design stage prediction.}

\item{ngroups}{The number of treatment groups for enrollment prediction
at the design stage. By default, it is set to 2.
It is replaced with the actual number of
treatment groups in the observed data if \code{df} is not \code{NULL}.}

\item{alloc}{The treatment allocation in a randomization block.
By default, it is set to \code{NULL}, which yields equal allocation
among the treatment groups.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500.}

\item{IA_included}{A Boolean variable to control whether or not to
include one interim analysis. By default, it is set to \code{FALSE}.}

\item{test}{a character denotes the test type, includes "Superiority","Futility","Two-sided"}

\item{test_IA}{a character denotes the test type in interim analysis, includes "Efficacy","Futility",or "Efficacy and Futility"}

\item{Futility_boundary}{a positive number denotes the boundary of the Futility in the scale of hazard ratio}

\item{seed.num}{The number of the random seed. The default is NULL.}
}
\value{
A list with following components
\itemize{
\item iteration0 - the number of simulations that achieved target number of events in interim analysis and primary analysis under null hypothesis.
\item iteration1 - the number of simulations that achieved target number of events in interim analysis and primary analysis under alternative hypothesis.
\item simu_summary - the summary table of number of simulations that achieved or do not achieve target number of events in each analysis under null hypothesis and alternative hypothesis.
\item power - the alpha and powers from log-rank test and Fleming&Harrington test
\item samplesize - the counts per arm and total, includes the number of patients,
events at interim analysis and primary analysis, events at interim analysis before delay,
events at primary analysis before delay
\item hzratio - average hazard ratio at primary analysis and interim analysis
\item hzrc - Frequencies of hazard ratios in specific zones
\item hzratio2 - HR before and after delay
\item median - Medians of survival time at interim analysis and primary analysis
\item osrate - survival rate at milestones (1, 2 and 4 years)
\item duration - Study duration for enrollment, interim analysis and primary analysis
\item duration1 - Durations for interim analysis and primary analysis with 95\% CI
\item textH0 - the summary text of number of simulations that achieved or do not achieve target number of events in primary analysis under null hypothesis.
\item textHA - the summary text of number of simulations that achieved or do not achieve target number of events in primary analysis under alternative hypothesis.
}
}
\description{
Provides summary and test statistics based on simulation.
}
\examples{
\donttest{
fit1 <- list(model = "piecewise uniform",
             theta = -0.58, 
             vtheta=0, accrualTime =0)
fit2<-list()
fit2[[1]] <- list(model = "weibull with cured population and delayed treatment", 
                  theta = c(-2.2,0,6.5,0,1), 
                  vtheta = matrix(0,5,5))
fit2[[2]] <- list(model = "weibull with cured population and delayed treatment", 
                 theta = c(-2.2,0,6.5,46,0.65), 
                 vtheta = matrix(0,5,5))
fit3 <-list()
fit3[[1]] <- list(model = "weibull with cured population and delayed treatment", 
                  theta = c(-2.2,0,6.5,0,1), 
                  vtheta = matrix(0,5,5))
fit3[[2]] <- list(model = "weibull with cured population and delayed treatment", 
                  theta = c(-2.2,0,6.5,0,1),
                  vtheta = matrix(0,5,5))
fit4 <-list()

fit4[[1]] <- list(model = "exponential", 
                   theta =log(0.0003), 
                   vtheta=0)
fit4[[2]] <- list(model = "exponential", 
                   theta =log(0.0003), 

                   vtheta=0)
test1<-test_procedure(pilevel=0.9,nyears=4,enroll_fit=fit1,
                      dropout_fit=fit4,enroll_prior=fit1,event_prior_h0=fit3,
                      event_prior_ha=fit2,dropout_prior=NULL,
                      target_n=200,target_IA_d=40,target_d=60,
                      ialpha=0.016,falpha=0.0450,
                      lag=46,by_fitted_enroll=FALSE,
                      by_fitted_dropout=FALSE,treatment_label=c('a','b'),
                      ngroups=2,alloc=c(1,1),nreps=100, IA_included=TRUE)
}                       
}
