% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSNEwrapper.R
\name{predict.tsneReductor}
\alias{predict.tsneReductor}
\title{tsneReductor prediction function}
\usage{
\method{predict}{tsneReductor}(object, k = NULL, ...)
}
\arguments{
\item{object}{A returned object of tsneReductor function}

\item{k}{The number is used for computing the means of #neighbors with min distance
(#Neighbor=sqrt(#Samples/k).}

\item{\dots}{New samples set}
}
\value{
tsneY:An embedding of new data
}
\description{
This function performs an embedding of new data using an existing embedding.
}
\examples{
library("mlbench")
data(Sonar)

rndSamples <- sample(nrow(Sonar),150)
trainData <- Sonar[rndSamples,]
testData <- Sonar[-rndSamples,]

tsne_trainData <- tsneReductor(trainData[,1:60],dim = 3,perplexity = 10,max_iter = 1000)

tsne_testData <- predict(tsne_trainData,k=3,testData[,1:60])
}
