% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head-neck-cancer-data.R
\docType{data}
\name{head_neck_cancer}
\alias{head_neck_cancer}
\title{Head and neck cancer}
\format{
A data frame with 96 observations.
}
\usage{
head_neck_cancer
}
\description{
Time-to-event data a randomized clinical trial to compare two therapies for
head and neck cancer.51 patients were treated with radiation only and 45
patients treated with radiation plus chemotherapy. The variables are:
}
\details{
\itemize{
\item Time: time (in days) to recurrence of the cancer.
\item Therapy: treatment applied to the patients.
\item Status: censorship indicators.
}
}
\examples{
data(head_neck_cancer)
par(mfrow = c(1,2))
hist(head_neck_cancer$Time, main="", xlab="Time (Days)")
plot(head_neck_cancer$Time, xlab = "Patient (subjects)", lty = 3, type="h")

}
\references{
\insertRef{Khan2018}{EstimationTools}
}
\keyword{datasets}
