% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_inference.R
\name{ts_pmm2_inference}
\alias{ts_pmm2_inference}
\title{Bootstrap inference for PMM2 time series models}
\usage{
ts_pmm2_inference(
  object,
  x = NULL,
  B = 200,
  seed = NULL,
  block_length = NULL,
  method = c("residual", "block"),
  parallel = FALSE,
  cores = NULL,
  debug = FALSE
)
}
\arguments{
\item{object}{object of class TS2fit}

\item{x}{(optional) original time series; if NULL, uses object@original_series}

\item{B}{number of bootstrap replications}

\item{seed}{(optional) for reproducibility}

\item{block_length}{block length for block bootstrap; if NULL, uses heuristic value}

\item{method}{bootstrap type: "residual" or "block"}

\item{parallel}{logical, whether to use parallel computing}

\item{cores}{number of cores for parallel computing}

\item{debug}{logical, whether to output additional diagnostic information}
}
\value{
data.frame with columns: Estimate, Std.Error, t.value, p.value
}
\description{
Bootstrap inference for PMM2 time series models
}
