% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{VarList.comp}
\alias{VarList.comp}
\title{Compute covariance matrices}
\usage{
VarList.comp(Ancestry)
}
\arguments{
\item{Ancestry}{a matrix with 0/1 entries representing the allele ancestries
of a bi-parental population at a set of markers  (0: homozygous for parent A
alleles and 1: homozygous for parent B alleles)}
}
\value{
A list of three covariance matrices
}
\description{
This function computes the covariance matrices associated with
the variance components of the EpiTest model: the segregation variance,
the (segregation \code{x} segregation) variance and the error variance
}
\examples{
## One bi-parental population, no weighting
data(Ancestry.list)
Ancestry <- Ancestry.list[[1]]
VarList <- VarList.comp(Ancestry = Ancestry)
purrr::map(VarList,~.x[1:5,1:5])
}
