% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{is_constrained}
\alias{is_constrained}
\alias{is_constrained.dist_spec}
\title{Check if a <dist_spec> is constrained, i.e. has a finite maximum or nonzero
CDF cutoff.}
\usage{
\method{is_constrained}{dist_spec}(x, ...)
}
\arguments{
\item{x}{A \verb{<dist_spec>}}

\item{...}{ignored}
}
\value{
Logical; TRUE if \code{x} is constrained
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
# A fixed gamma distribution with mean 5 and sd 1.
dist1 <- Gamma(mean = 5, sd = 1, max = 20)

# An uncertain lognormal distribution with meanlog and sdlog normally
# distributed as Normal(3, 0.5) and Normal(2, 0.5) respectively
dist2 <- LogNormal(
  meanlog = Normal(3, 0.5),
  sdlog = Normal(2, 0.5),
  max = 20
)

# both distributions are constrained and therefore so is the sum
is_constrained(dist1 + dist2)
}
