% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.record.R
\name{record_raw_object}
\alias{record_raw_object}
\title{Record an Arbitrary Object During a Simulation}
\usage{
record_raw_object(dat, at, label, object)
}
\arguments{
\item{dat}{Main \code{netsim_dat} object containing a \code{networkDynamic}
object and other initialization information passed from
\code{\link{netsim}}.}

\item{at}{The time where the recording happens.}

\item{label}{The name to give to the recorded object.}

\item{object}{The object to be recorded.}
}
\value{
The updated \code{netsim_dat} main list object.
}
\description{
This function records any object during a simulation to allow its
inspection afterward. The records are stored in \code{dat[["raw.records"]]}
during the simulation, where \code{dat} is the main \code{netsim_dat} class
object, and in the \code{netsim} object under the \code{raw.records}
\code{collections::queue} object.
}
\details{
See the "Time-Varying Parameters" section of the "Working With Model
Parameters" vignette.
}
\examples{
\dontrun{

dat <- record_raw_object(dat, at, "a.df", data.frame(x = 2:200))
dat <- record_raw_object(dat, at, "a.message", "I recorded something")

}

}
