% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIRAdditiveNoise.R
\name{SIRAdditiveNoise}
\alias{SIRAdditiveNoise}
\title{SIR model with constant additive noise (P 6.1).}
\usage{
SIRAdditiveNoise(pars = NULL, init = NULL, time = NULL, step = 1, ...)
}
\arguments{
\item{pars}{\code{\link{vector}} with 5 values: the transmission rate, the recovery rate, the birth (deadth) rate, the amount of noise experienced in the transmission rate and the population size assumed to be constant. The names of these values must be "beta", "gamma", "mu", "noise", and "N" respectively.}

\item{init}{\code{\link{vector}} with 2 values: the initial number of susceptibles and infectious. The names of these values must be "X", and "Y", respectively. "X" and "Y" must be positive and are numbers not proportions.}

\item{time}{time sequence for which output is wanted; the first value of times must be the initial time.}

\item{step}{step size to set the integration step and to scale the noise term.}

\item{...}{further arguments passed to \link[deSolve]{ode} function.}
}
\value{
\code{\link{list}}. The first element, \code{*$model}, is the model function. The second, third and fourth elements are the vectors \code{*$pars}, \code{*$init} and \code{*$time}, containing the \code{pars}, \code{init} and \code{time} arguments of the function. The fifth element \code{*$results} is a \code{\link{data.frame}} with up to as many rows as elements in time. First column contains the time. Second and third columns contain the number of susceptibles and recovered.
}
\description{
Solves a SIR model with constant additive noise added to the transmission rate.
}
\details{
This is the R version of program 6.1 from page 194 of "Modeling Infectious Disease in humans and animals" by Keeling & Rohani.
}
\examples{
# Parameters and initial conditions.
parameters <- c(beta = 1, gamma = 1 / 10, mu = 1 / (50 * 365),
                noise = 10, N = 1e6)
initials <- c(X = 1e5, Y = 500)

# Solve and plot.
sir.additive.noise <- SIRAdditiveNoise(pars = parameters, init = initials,
                                       time = 0:(2 * 365), step = 1)
PlotMods(sir.additive.noise)

}
\references{
Keeling, Matt J., and Pejman Rohani. Modeling infectious diseases in humans and animals. Princeton University Press, 2008.
}
\seealso{
\link[deSolve]{ode}.
}
