% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_absdet}
\alias{Eigen_absdet}
\title{Absolute value of the determinant}
\usage{
Eigen_absdet(M)
}
\arguments{
\item{M}{a \emph{real} square matrix}
}
\value{
The absolute value of the determinant of \code{M}.
}
\description{
Absolute value of the determinant of a real matrix.
}
\note{
`Eigen_absdet(M)` is not faster than `abs(Eigen_det(M))`.
}
\examples{
set.seed(666L)
M <- matrix(rpois(25L, 1), 5L, 5L)
Eigen_absdet(M)
}
