# EcoTroph
EcoTroph (ET) is a modelling approach articulated around the idea that an ecosystem can be represented by its biomass distribution across trophic levels, the biomass trophic spectrum (Gascuel et al., 2005). The ecosystem functioning is viewed as a biomass flow moving from lower to higher trophic levels, due to predation and ontogenetic processes (Gascuel et al. 2009 and 2011). Thus, the ecosystem biomass present at a given trophic level may be estimated from two simple equations, one describing biomass flow, the other their kinetics (which quantifies the velocity of biomass transfers towards top predators).

Such an approach, wherein species as such disappear, may be regarded as the ultimate stage in the use of the trophic level metric for ecosystem modelling. By concentrating on biomass flow as a quasi-physical process, it allows aspects of ecosystem functioning to be explored which are complementary to EwE. It provides users with simple tools to quantify the impacts of fishing at an ecosystem scale and a new way of looking at ecosystems. It thus appears a useful complement to existing ecosystem model such as Ecopath or Osmose.

EcoTroph can be used either in association with an existing Ecopath model or as a stand-alone application, especially in data-poor environments. Furthermore the model can be applied directly through the plug-in developed within the EwE software or the R package available in the Download page. This package constitutes an updated version of the ET model (conform to Gascuel et al., 2011). 


