% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecometrics.R
\name{select_optimal_model}
\alias{select_optimal_model}
\title{Choosing Best Model Based on AIC, BIC and Adjusted R Squared}
\usage{
select_optimal_model(models, criterion = "AIC")
}
\arguments{
\item{models}{a list of models}

\item{criterion}{The criterion to select optimal model. Default AIC}
}
\value{
list of the results and best model
}
\description{
Choosing Best Model Based on AIC, BIC and Adjusted R Squared
}
\examples{
data(eduperform)
model1 <- lm(pi ~ hs, data = eduperform)
model2 <- lm(pi ~ hs + ps, data = eduperform)
model3 <- lm(pi ~ hs + ps + sh, data = eduperform)
models <- list(model1, model2, model3)

select_optimal_model(models, criterion= "AIC")

}
\author{
Mutua Kilai
}
