% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationMatrixClass.R
\docType{class}
\name{MutationMatrix-class}
\alias{MutationMatrix-class}
\title{Mutation matrix}
\description{
A mutation matrix is used to simulate mutations that affect loci. An object
of the class \code{MutationMatrix} does not only contain a (haplotypic)
mutation matrix. It also contains the attributes necessary for the
construction and easy-to-read display of this matrix.
}
\details{
The mutation matrix itself is a square matrix of size equal to the number of
haplotypes. It is a probability matrix in that the sum of the values in
each row is equal to 1. For a given haplotype, the row associated with it
describes the probabilistic proportions that lead by mutation of this
haplotype to the production of the other haplotypes (and of itself if there
are no mutations).
}
\section{Slots}{

\describe{
\item{\code{mutHapLoci}}{a list of haploid locus by locus allelic mulation matrices.}

\item{\code{mutDipLoci}}{a list of diploid locus by locus allelic mulation matrices.}

\item{\code{mutLoci}}{a list concatenating \code{mutHapLoci} and \code{mutDipLoci}}

\item{\code{nbAlDL}}{a vector of the number(s) of alleles at each haploid locus}

\item{\code{nbAlHL}}{a vector of the number(s) of alleles at each diploid locus}

\item{\code{mutationMatrix}}{the haplotypic mutation matrix}

\item{\code{nbHaplo}}{the number of haplotypes}

\item{\code{nbDL}}{the number of diploid loci}

\item{\code{nbHL}}{the number of haploid loci}

\item{\code{haplotypes}}{the enumeration of haplotypes}

\item{\code{IDgenome}}{ID of the associated genome}
}}

\author{
Ehouarn Le Faou
}
